%--------------------------------------------------------------------------
% Project Name:   Image Filter Arrays
% File Name:      Simulate4_Main.m
% Authors:        JF Heukelman   005538085
%                 J Peterson     005567016
% Class:          PSYCH221
% Description:    This runs the project for 4 sensor colors
%--------------------------------------------------------------------------
close all; clear all; clc;
warning('OFF');

Recover = false;         % Used if the simulation has been interrupted and
                         % we need to pick up where we left off
if(Recover)
    load Simulate4Data.mat;
    load Simulate4_sensorIndex.mat;
    load SavedData4;
    load SensorData4.mat;
else
    % Generate all the sensor data that we will be using in SensorData5.mat
    GenSensorData4; clear all; 
    load SensorData4.mat
   
    NumRows = size(sensorSettings,1);       % Number of different sensors that we're running
    colorMetrics = zeros(NumRows,1);        % Initialize vector to save color metrics            
    noiseMetrics = zeros(NumRows,1);        % Initialize vector to save noise metrics
    frequencyMetrics = zeros(NumRows,1);    % Initialize vector to save frequency metrics

    sensorIndex = 1;
    analysisIndex = 1;
    save('SavedData4.mat','colorMetrics','noiseMetrics','frequencyMetrics','sensorIndex','analysisIndex');
end


% Loop through all the sensors
Simulate4_Sub;


% Put the results into a matrix that we can save
%--------------------------------------------------------
ResultNames4 = sensorSettings_Names;
Results4 = sensorSettings;

Results4 = [Results4 colorMetrics frequencyMetrics noiseMetrics]; 
ResultNames4 = {ResultNames4{:},'deltaE','MTF50','yNoise'};


% Display the results
disp(ResultNames4);
disp(Results4);

% Save the final results
save('Results_4.mat', 'ResultNames4', 'Results4');

% Plot the final results

colors = ['r', 'g', 'b', 'y', 'c', 'm', 'k'];
figure(1);
plot(frequencyMetrics, colorMetrics, 'bo');
xlabel('MTF-50');
ylabel('Average \Delta E');
title('\bfColor Accuracy vs Frequency Accuracy, 4 colors');
grid on;
axis([0 max(1.2*frequencyMetrics) 0 max(1.2*colorMetrics)]);

saveas(gcf, ['./Images/Results_4.png']);






